<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <meta http-equiv="X-UA-Compatible" content="ie=edge">
  <!-- Logo -->
  <link rel="icon" href="all_style/img/logo1.png" type="image/x-icon">
  <!-- Bootstrap CSS -->
  <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/css/bootstrap.min.css">
  <!-- Font Awesome-->
  <link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.7.2/css/all.css">
  <!-- Carousel -->
  <link rel="stylesheet" href="all_style/owl-carousel/css/owl.carousel.min.css">
  <link rel="stylesheet" href="all_style/owl-carousel/css/owl.theme.default.min.css">
  <!-- Css -->
  <link rel="stylesheet" href="all_style/css/style.css">
  <title>premium-ssl-certificates</title>
  <style>
  p {
    font-size: 16px;
    line-height: 1.5rem;
  }

  #premium-ssl {
    background-image: linear-gradient(to right, rgb(11, 22, 54), rgb(46, 12, 46));
    height: 300px;

  }

  #premium-ssl .social-icon i {
    font-size: 23px;
    padding: 10px;
    color: white;
  }

  #premium-ssl .social-icon i {
    height: 45px;
    width: 45px;
    border: 2px solid #9e0bb5;
    color: #9e0bb5;
    border-radius: 50px;
  }

  #premium-ssl .social-icon i:hover {
    background-color: #4C0353;
    border-radius: 50px;
    color: whitesmoke;
  }

  #premium-ssl-article h2,
  h3,
  h5 {
    color: #429CFD;
  }
  </style>



</head>

<body>
  <?php
include('header.php');
?>

  <section id="premium-ssl">
    <div class="container py-5">
      <div class="text-center text-light">
        <h1 class="pt-3">Premium SSL Certificates</h1>
        <p style="letter-spacing: 3px;">For school, legal entity or public organization</p>
      </div>
      <div class="social-icon text-right">
        <P class="text-light" style="letter-spacing: 5px;">Ask What People Think</P>
        <a href="#"><i class="fab fa-facebook-f text-center"></i></a>
        <a href="#"><i class="fab fa-twitter text-center"></i></a>
        <a href="#"><i class="fab fa-google-plus-g text-center"></i></a>
      </div>
    </div>
  </section>

  <section id="premium-ssl-article">
    <div class="container pt-5">
      <h3>Description</h3>
      <h2>Comodo PremiumSSL</h2>
      <p> Whether you represent a school, a legal entity or a public organization, customer trust is key to success. A
        good way to earn this trust is to establish yourself as a legal company. Comodo verifies your company and
        attests that you're the real deal by displaying your company name and address on the site seal and certificate
        they issue for you.<br><br>

        Comodo PremiumSSL is normally issued within 2 business days. Your business must be legally registered with the
        appropriate Government Registration Agency in the country or state you apply from. Make sure your company
        address and phone number match the ones in "third-party" public telephone listings, or you won't be able to
        receive the verification call from Comodo and they may require additional paperwork for you to prove your
        identity. If you’ve moved or changed the phone number, notify Comodo as soon as you get their email with the
        list of paperwork they require and other dull but necessary instructions, and they'll help you update it. Domain
        name must be registered to your organization's legal name in a publicly viewable WHOIS search, and the address
        on WHOIS must match the one in CSR.<br><br>

        While web security is the feature that all SSLs share, encryption levels vary. The larger the key, the more
        unbreakable it is. PremiumSSL supports from 40-bit to 256-bit large keys. The exact value depends on the
        hardware/software combination the end user owns. Modern browsers use 128- to 256-bit encryption; those that use
        40-bit are ancient history now.<br><br>

        Don't worry you'll forget to renew your certificate — we send reminders 30 days prior to expiration. Please keep
        your email up-to-date so we can reach you. </p>




      <h3>FAQ</h3>
      <h5>Q: Where do I put my domain name, to activate the certificate?</h5>
      <p>A: Contact your hosting provider, ask them to generate a CSR (certificate signing request) for your domain
        name, and then get back to us.</p>

      <h5>Q: What domain should I use? With www or without?</h5>
      <p>A: It doesn't matter. Comodo PremiumSSL is flexible. Regardless what you enter in the CSR, it covers 1 domain
        with "www" and without (www.site.com and site.com). Same goes for subdomains.</p>

      <h5>Q: What else do I need to check before activating SSL?</h5>
      <p>A: Get a CSR from your hosting provider and a dedicated IP if your host doesn't allow SSL installation on a
        shared IP. CSR company name and contact info must match the ones in third-party telephone listings and publicly
        viewable WHOIS. WHOIS privacy protection tools must be turned off.</p>

      <h5>Q: So cheap! Do you have any hidden fees?</h5>
      <p>A: Nope, we are a platinum partner of Comodo and offer the lowest prices on the market for any Comodo products.
      </p>

      <h5>Q: What does warranty mean?</h5>
      <p>A: Comodo will pay warranty to the victim of an online fraud if personal data is stolen via secure connection.
        But in case you were wondering, it's beyond human comprehension to break a 128- to 256-bit cert.</p>

      <h5>Q: What's SSL assurance?</h5>
      <p>A: The higher the assurance level, the more information you need to provide to the certificate authority for
        them to approve your request. With Comodo PremiumSSL, you get high assurance, meaning the verification procedure
        involves legal verification.</p>
    </div>
  </section>

  <?php
include('footer.php');
?>


  <!-- All Script Links-->
  <!-- jQuery first, then Popper.js, then Bootstrap JS -->
  <script src="https://code.jquery.com/jquery-3.3.1.slim.min.js"></script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.14.7/umd/popper.min.js"></script>
  <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/js/bootstrap.min.js"></script>
  <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.3.1/jquery.min.js"></script>


  <script src="all_style/owl-carousel/js/owl.carousel.min.js"></script>
  <script>
  $('.owl-carousel').owlCarousel({
    loop: true,
    margin: 10,
    nav: false,
    autoplay: 1000,
    responsive: {
      0: {
        items: 0
      },
      600: {
        items: 1
      },
      1000: {
        items: 6
      }
    }
  })
  </script>
</body>

</html>