<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <meta http-equiv="X-UA-Compatible" content="ie=edge">
  <!-- Logo -->
  <link rel="icon" href="all_style/img/logo1.png" type="image/x-icon">
  <!-- Bootstrap CSS -->
  <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/css/bootstrap.min.css">
  <!-- Font Awesome-->
  <link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.7.2/css/all.css">
  <!-- Carousel -->
  <link rel="stylesheet" href="all_style/owl-carousel/css/owl.carousel.min.css">
  <link rel="stylesheet" href="all_style/owl-carousel/css/owl.theme.default.min.css">
  <!-- Css -->
  <link rel="stylesheet" href="all_style/css/style.css">
  <title>mvc-hosting</title>


  <style>
  #mvc-hosting {
    background-image: url(all_style/img/xhero-bg.jpeg.pagespeed.ic.44oor01KSH.webp);
    background-size: cover;
    background-repeat: no-repeat;
    background-position: center;
    background-attachment: fixed;
    width: 100%;
    height: auto;
  }

  p {
    font-size: 16px;
    line-height: 2rem;
  }

  #mvc-hosting a {
    letter-spacing: 3px;
    margin-top: 10px;
  }

  #mvc-hosting .custom-button {
    border: 1px solid white;
    color: white;

  }

  #mvc-hosting .custom-button:hover {
    background-color: #2C0D2F;
    color: white;
    border: 1px solid #2C0D2F;
  }

  #mvc-different-solution a {
    letter-spacing: 3px;
    margin-top: 10px;
  }

  #mvc-different-solution .custom-button {
    border: 2px solid #4c0353;
    color: #9e1cab;

  }

  #mvc-different-solution .custom-button:hover {
    background-color: #2C0D2F;
    color: white;
    border: 2px solid #2C0D2F;
  }

  #mvc-different-solution {
    background-image: linear-gradient(to right, rgb(11, 22, 54), rgb(46, 12, 46));
  }

  #mvc-article i {
    font-size: 40px;
    color: #0C1535;
  }

  #mvc-article .article {
    box-shadow: 0 4px 8px 0 rgba(0, 0, 0, 0.2), 0 6px 20px 0 rgba(0, 0, 0, 0.19);
    background-color: #F3F3F3;


  }

  #more {
    display: none;
  }
  </style>
</head>


<body>


  <?php
include('header.php');
?>


  <section id="mvc-hosting">
    <div class="container py-5">
      <div class="text-center text-light">
        <h1>MVC Hosting - Industry Best Solutions</h1>
        <p class="pt-4">Our goal isn't to win awards. Our goal is to offer the best web host solutions that are both
          blazing fast and ultra-reliable. Even so, we're still extremely proud of our team's accomplishments! Since our
          launch in 2003, their hard work has helped us earn recognition and accolades as the top hosting provider in
          the industry. </p>
        <a href="#" class="btn btn custom-button text-light py-2 px-4">GET STARTED</a>
      </div>
    </div>
  </section>


  <section id="mvc-different-solution">
    <div class="container py-5">
      <div class="text-center text-light">
        <h1>MVC Hosting - Need A Different Solution?</h1>
        <p class="py-3">Not seeing the hosting solution that you want or need? Don't worry! We have a whole range of
          services that are bound to fit your specific hosting needs. At A2 Hosting, we offer Shared, Reseller and VPS
          services as well as Managed WordPress solutions.Looking for a new domain name or SSL Certificate? We've got
          you covered there as well! Just click the button below to visit our Web Hosting comparison page. That's where
          you'll see a full breakdown of each of our Windows Hosting services.</p>
        <a href="#" class="btn btn custom-button py-2 px-4">COMPARE WINDOWS HOSTING</a>
      </div>
    </div>
  </section>


  <section id="mvc-article">
    <div class="container text-center py-5">
      <h2>MVC Hosting - What Our Customers Have To Say?</h2>
      <h5 class="pb-4">97% of A2 Hosting users have said that they would recommend our services to a friend. Below are
        just a few examples of reviews from those customers.</h5>
      <div class="row">
        <div class="col-md-4">
          <div class="article pb-5 mb-3">
            <div class="star-group d-flex py-4 ml-5">
              <i class="fas fa-star"></i>
              <i class="fas fa-star"></i>
              <i class="fas fa-star"></i>
              <i class="fas fa-star"></i>
              <i class="fas fa-star"></i>
            </div>
            <p class="px-5">“A2 Hosting was very quick to help when I had issues migrating my site from Windows to
              Linux.” </p>
            <h6 class="px-5">— Bryan E. December 4, 2019</h6>
          </div>
        </div>
        <div class="col-md-4">
          <div class="article pb-5 mb-3">
            <div class="star-group d-flex py-4 ml-5">
              <i class="fas fa-star"></i>
              <i class="fas fa-star"></i>
              <i class="fas fa-star"></i>
              <i class="fas fa-star"></i>
              <i class="fas fa-star"></i>
            </div>
            <p class="px-5">“A2 Hosting was very quick to help when I had issues migrating my site from Windows to
              Linux.” </p>
            <h6 class="px-5">— Bryan E. December 4, 2019</h6>
          </div>
        </div>
        <div class="col-md-4">
          <div class="article pb-5 mb-3">
            <div class="star-group py-4 ml-5">
              <i class="fas fa-star"></i>
              <i class="fas fa-star"></i>
              <i class="fas fa-star"></i>
              <i class="fas fa-star"></i>
              <i class="fas fa-star"></i>
            </div>
            <p class="px-5">“A2 Hosting was very quick to help when I had issues migrating my site from Windows to
              Linux.” </p>
            <h6 class="px-5">— Bryan E. December 4, 2019</h6>
          </div>
        </div>
      </div>
    </div>
  </section>


  <?php
include('footer.php');
?>


  <!-- All Script Links-->
  <!-- jQuery first, then Popper.js, then Bootstrap JS -->
  <script src="https://code.jquery.com/jquery-3.3.1.slim.min.js"></script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.14.7/umd/popper.min.js"></script>
  <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/js/bootstrap.min.js"></script>
  <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.3.1/jquery.min.js"></script>



  <script src="all_style/owl-carousel/js/owl.carousel.min.js"></script>
  <script>
  $('.owl-carousel').owlCarousel({
    loop: true,
    margin: 10,
    nav: false,
    autoplay: 1000,
    responsive: {
      0: {
        items: 0
      },
      600: {
        items: 1
      },
      1000: {
        items: 6
      }
    }
  })
  </script>

  <script>
  function myFunction() {
    var dots = document.getElementById("dots");
    var moreText = document.getElementById("more");
    var btnText = document.getElementById("myBtn");

    if (dots.style.display === "none") {
      dots.style.display = "inline";
      btnText.innerHTML = "Read more";
      moreText.style.display = "none";
    } else {
      dots.style.display = "none";
      btnText.innerHTML = "Read less";
      moreText.style.display = "inline";
    }
  }
  </script>
</body>

</html>