<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <meta http-equiv="X-UA-Compatible" content="ie=edge">
  <!-- Logo -->
  <link rel="icon" href="all_style/img/logo1.png" type="image/x-icon">
  <!-- Bootstrap CSS -->
  <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/css/bootstrap.min.css">
  <!-- Font Awesome-->
  <link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.7.2/css/all.css">
  <!-- Carousel -->
  <link rel="stylesheet" href="all_style/owl-carousel/css/owl.carousel.min.css">
  <link rel="stylesheet" href="all_style/owl-carousel/css/owl.theme.default.min.css">
  <!-- Css -->
  <link rel="stylesheet" href="all_style/css/style.css">
  <title>cloud-hosting</title>
  <style>
  .hr {
    border: 1px solid white;
    width: 600px;

  }

  p {
    font-size: 16px;
    line-height: 1.5rem;
  }

  #cloud-bg {
    background-image: url(all_style/img/stage-company.jpg);
    background-size: cover;
    background-repeat: no-repeat;
    background-position: center;
    background-attachment: fixed;
    width: 100%;
  }

  #cloud-cPanel {
    background-image: linear-gradient(to right, rgb(11, 22, 54), rgb(46, 12, 46));
  }

  #cloud-cPanel a {
    letter-spacing: 3px;
    margin-top: 10px;
  }

  #cloud-bg .custom-button {
    border: 1px solid white;
    color: white;

  }

  #cloud-bg .custom-button:hover {
    background-color: #2C0D2F;
    color: white;
    border: 1px solid #2C0D2F;
  }

  #cloud-cPanel .custom-button {
    border: 2px solid #4c0353;
    color: #b528c2;

  }

  #cloud-cPanel .custom-button:hover {
    background-color: #2C0D2F;
    color: white;
    border: 2px solid #2C0D2F;
  }
  </style>

</head>

<body>
  <?php
include('header.php');
?>


  <section id="cloud-bg">
    <div class="container py-5">
      <div class="text-center text-light">
        <h1 style="letter-spacing: 10px;">CLOUD HOSTING</h1>
        <hr class="hr">
        <h4 class="text-center pt-3" style="letter-spacing: 3px;">Stay in control of your Cloud Hosting</h4>
        <p class="px-5" style="letter-spacing: 2px;">Your control panel will show your current usage for the month as
          well as your estimated usage until your next invoice, helping you to stay on top of your hosting costs. You
          can also view all of your previous invoices in one location.</p>
        <a href="#" class="btn btn custom-button mt-4 px-5 text-light" style="letter-spacing: 8px;">GET CLOUD
          HOSTING</a>
      </div>
    </div>
  </section>


  <section id="cloud-hosting">
    <div class="container py-5">
      <div class="row">
        <div class="col-md-7">
          <h3>Cloud Hosting</h3>
          <p>Hyve Managed Cloud is our core hosting offering. Created by cloud experts with over 15 years industry
            experience, Hyve Managed Cloud is hosted on our own infrastructure, giving us full control. Unlike a public
            cloud solution, Hyve Managed Cloud is only used by our verified customers for added security.</p>
          <div class="row">
            <div class="col-md-6">
              <h4 class="py-2" style="border-bottom: 2px solid #03C1DE;">Managed Cloud</h4>
              <p>Fully managed enterprise multi-tenant VMware cloud delivers high-performance, reliability and
                scalability.</p>
            </div>
            <div class="col-md-6">
              <h4 class="py-2" style="border-bottom: 2px solid #03C1DE;">Private Cloud</h4>
              <p>All the benefits of Managed Cloud, with the added security and control of dedicated hardware.</p>
            </div>
          </div>
          <div class="row">
            <div class="col-md-6">
              <h4 class="py-2" style="border-bottom: 2px solid #03C1DE;">Hybrid Cloud</h4>
              <p>Scale out your on-premise servers to our cloud. Integrate with your legacy systems.</p>
            </div>
            <div class="col-md-6">
              <h4 class="py-2" style="border-bottom: 2px solid #03C1DE;">Cloud Server Speed</h4>
              <p>See the independent speed tests benchmarking our cloud against the competition.</p>
            </div>
          </div>
        </div>
        <div class="col-md-5">
          <div class="clients-testimonial">
            <h3 class="text-center"><i>Clients Testimonial</i></h3>
            <h4 class="text-center py-3">Success Stories</h4>
            <p>Our clients span a wide range of industries from technology and telecommunications to healthcare and
              financial services. Some are market leaders, others are just starting out. Regardless of their size, all
              are unique and we are very proud to be working with each and every one.</p>
          </div>

        </div>
      </div>
      <div class="banifit-cloud-hosting">
        <h4 class="text-center py-5">Benefits of Cloud Hosting</h4>
        <div class="row">
          <div class="col-md-3">
            <h4 class="py-2" style="border-bottom: 2px solid #03C1DE;">Reliable</h4>
            <p>No single point of failure' architecture and 'no-compromise' approach to hardware investment guarantees
              unbeatable cloud server reliablilty.</p>
          </div>
          <div class="col-md-3">
            <h4 class="py-2" style="border-bottom: 2px solid #03C1DE;">Super-Fast</h4>
            <p>High performance SSD drives are key to our cloud offering. They provide 'light-speed' disk access, making
              our cloud the fastest on the market today.</p>
          </div>
          <div class="col-md-3">
            <h4 class="py-2" style="border-bottom: 2px solid #03C1DE;">Secure</h4>
            <p>Hyve is the only cloud host offering Intrusion Prevention & DDoS Defence. Our strict compliance includes
              ISO 27001 and PCI DSS. We also offer PCI cloud servers.</p>
          </div>
          <div class="col-md-3">
            <h4 class="py-2" style="border-bottom: 2px solid #03C1DE;">Scalable</h4>
            <p>Instantly adapt cloud resources to respond to web traffic events and sales & marketing drives, allowing
              more effective use of hosting budgets.</p>
          </div>
        </div>
      </div>
    </div>
  </section>

  <section id="cloud-cPanel">
    <div class="container py-5">
      <div class="row">
        <div class="col-md-8 offset-md-2 text-light">
          <h2 class="text-center" style="letter-spacing: 3px;">Try our cloud hosting control panel now</h2>
          <p class="text-center" style="letter-spacing: 2px;">Manage your entire cloud infrastructure from a single
            intuitive control panel. Configure your Cloud Hosting exactly as you need it, with the ability to deploy and
            scale your virtual machines up or down at any time. With no contract, there's nothing to stop you getting
            started right now.</p>
          <a href="#" class="btn btn btn-block custom-button mt-5">SIGN UP</a>
        </div>
      </div>

    </div>
  </section>



  <?php
include('footer.php');
?>


  <!-- All Script Links-->
  <!-- jQuery first, then Popper.js, then Bootstrap JS -->
  <script src="https://code.jquery.com/jquery-3.3.1.slim.min.js"></script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.14.7/umd/popper.min.js"></script>
  <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/js/bootstrap.min.js"></script>
  <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.3.1/jquery.min.js"></script>



  <script src="all_style/owl-carousel/js/owl.carousel.min.js"></script>
  <script>
  $('.owl-carousel').owlCarousel({
    loop: true,
    margin: 10,
    nav: false,
    autoplay: 1000,
    responsive: {
      0: {
        items: 0
      },
      600: {
        items: 1
      },
      1000: {
        items: 6
      }
    }
  })
  </script>
</body>

</html>